/*
 * Decompiled with CFR 0.152.
 */
package silk;

import java.io.PrintWriter;
import silk.InputPort;
import silk.Pair;
import silk.Scheme;

public abstract class SchemeUtils {
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    public static Double ZERO = new Double(0.0);
    public static Double ONE = new Double(1.0);

    public static Boolean truth(boolean bl) {
        if (bl) {
            return TRUE;
        }
        return FALSE;
    }

    public static boolean truth(Object object) {
        return object != FALSE;
    }

    public static Double num(double d) {
        if (d == 0.0) {
            return ZERO;
        }
        if (d == 1.0) {
            return ONE;
        }
        return new Double(d);
    }

    public static double num(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return SchemeUtils.num(SchemeUtils.error("expected a number, got: " + object));
    }

    public static char chr(Object object) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return SchemeUtils.chr(SchemeUtils.error("expected a char, got: " + object));
    }

    public static Character chr(char c) {
        return new Character(c);
    }

    public static char[] str(Object object) {
        if (object instanceof char[]) {
            return (char[])object;
        }
        return SchemeUtils.str(SchemeUtils.error("expected a string, got: " + object));
    }

    public static String sym(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return SchemeUtils.sym(SchemeUtils.error("expected a symbol, got: " + object));
    }

    public static Object[] vec(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        return SchemeUtils.vec(SchemeUtils.error("expected a vector, got: " + object));
    }

    public static InputPort inPort(Object object, Scheme scheme) {
        if (object == null) {
            return scheme.input;
        }
        if (object instanceof InputPort) {
            return (InputPort)object;
        }
        return SchemeUtils.inPort(SchemeUtils.error("expected an input port, got: " + object), scheme);
    }

    public static PrintWriter outPort(Object object, Scheme scheme) {
        if (object == null) {
            return scheme.output;
        }
        if (object instanceof PrintWriter) {
            return (PrintWriter)object;
        }
        return SchemeUtils.outPort(SchemeUtils.error("expected an output port, got: " + object), scheme);
    }

    public static Object error(String string) {
        System.err.println("**** ERROR: " + string);
        throw new RuntimeException(string);
    }

    public static Object warn(String string) {
        System.err.println("**** WARNING: " + string);
        return "<warn>";
    }

    public static Object first(Object object) {
        if (object instanceof Pair) {
            return ((Pair)object).first;
        }
        return null;
    }

    public static Object rest(Object object) {
        if (object instanceof Pair) {
            return ((Pair)object).rest;
        }
        return null;
    }

    public static Object setFirst(Object object, Object object2) {
        if (object instanceof Pair) {
            ((Pair)object).first = object2;
            return ((Pair)object).first;
        }
        return SchemeUtils.error("Attempt to set-car of a non-Pair:" + SchemeUtils.stringify(object));
    }

    public static Object setRest(Object object, Object object2) {
        if (object instanceof Pair) {
            ((Pair)object).rest = object2;
            return ((Pair)object).rest;
        }
        return SchemeUtils.error("Attempt to set-cdr of a non-Pair:" + SchemeUtils.stringify(object));
    }

    public static Object second(Object object) {
        return SchemeUtils.first(SchemeUtils.rest(object));
    }

    public static Object third(Object object) {
        return SchemeUtils.first(SchemeUtils.rest(SchemeUtils.rest(object)));
    }

    public static Pair list(Object object, Object object2) {
        return new Pair(object, new Pair(object2, null));
    }

    public static Pair list(Object object) {
        return new Pair(object, null);
    }

    public static Object listStar(Object object) {
        if (SchemeUtils.rest(object) == null) {
            return SchemeUtils.first(object);
        }
        return SchemeUtils.cons(SchemeUtils.first(object), SchemeUtils.listStar(SchemeUtils.rest(object)));
    }

    public static Pair cons(Object object, Object object2) {
        return new Pair(object, object2);
    }

    public static Object reverse(Object object) {
        Pair pair = null;
        while (object instanceof Pair) {
            pair = SchemeUtils.cons(SchemeUtils.first(object), pair);
            object = SchemeUtils.rest(object);
        }
        return pair;
    }

    public static boolean equal(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        if (object instanceof char[]) {
            if (!(object2 instanceof char[])) {
                return false;
            }
            char[] cArray = (char[])object;
            char[] cArray2 = (char[])object2;
            if (cArray.length != cArray2.length) {
                return false;
            }
            int n = cArray.length - 1;
            while (n >= 0) {
                if (cArray[n] != cArray2[n]) {
                    return false;
                }
                --n;
            }
            return true;
        }
        if (object instanceof Object[]) {
            if (!(object2 instanceof Object[])) {
                return false;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            int n = objectArray.length - 1;
            while (n >= 0) {
                if (!SchemeUtils.equal(objectArray[n], objectArray2[n])) {
                    return false;
                }
                --n;
            }
            return true;
        }
        return object.equals(object2);
    }

    public static boolean eqv(Object object, Object object2) {
        return object == object2 || object instanceof Double && object.equals(object2) || object instanceof Character && object.equals(object2);
    }

    public static int length(Object object) {
        int n = 0;
        while (object instanceof Pair) {
            ++n;
            object = ((Pair)object).rest;
        }
        return n;
    }

    public static char[] listToString(Object object) {
        char[] cArray = new char[SchemeUtils.length(object)];
        int n = 0;
        while (object instanceof Pair) {
            cArray[n] = SchemeUtils.chr(SchemeUtils.first(object));
            object = SchemeUtils.rest(object);
            ++n;
        }
        return cArray;
    }

    public static Object[] listToVector(Object object) {
        Object[] objectArray = new Object[SchemeUtils.length(object)];
        int n = 0;
        while (object instanceof Pair) {
            objectArray[n] = SchemeUtils.first(object);
            object = SchemeUtils.rest(object);
            ++n;
        }
        return objectArray;
    }

    public static Object write(Object object, PrintWriter printWriter, boolean bl) {
        printWriter.print(SchemeUtils.stringify(object, bl));
        printWriter.flush();
        return object;
    }

    public static Pair vectorToList(Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Pair pair = null;
            int n = objectArray.length - 1;
            while (n >= 0) {
                pair = SchemeUtils.cons(objectArray[n], pair);
                --n;
            }
            return pair;
        }
        SchemeUtils.error("expected a vector, got: " + object);
        return null;
    }

    static void stringify(Object object, boolean bl, StringBuffer stringBuffer) {
        if (object == null) {
            stringBuffer.append("()");
            return;
        }
        if (object instanceof Double) {
            double d = (Double)object;
            if ((double)Math.round(d) == d) {
                stringBuffer.append((long)d);
                return;
            }
            stringBuffer.append(d);
            return;
        }
        if (object instanceof Character) {
            if (bl) {
                stringBuffer.append("#\\");
            }
            stringBuffer.append(object);
            return;
        }
        if (object instanceof Pair) {
            ((Pair)object).stringifyPair(bl, stringBuffer);
            return;
        }
        if (object instanceof char[]) {
            char[] cArray = (char[])object;
            if (bl) {
                stringBuffer.append('\"');
            }
            int n = 0;
            while (n < cArray.length) {
                if (bl && cArray[n] == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(cArray[n]);
                ++n;
            }
            if (bl) {
                stringBuffer.append('\"');
                return;
            }
        } else {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                stringBuffer.append("#(");
                int n = 0;
                while (n < objectArray.length) {
                    SchemeUtils.stringify(objectArray[n], bl, stringBuffer);
                    if (n != objectArray.length - 1) {
                        stringBuffer.append(' ');
                    }
                    ++n;
                }
                stringBuffer.append(')');
                return;
            }
            if (object == TRUE) {
                stringBuffer.append("#t");
                return;
            }
            if (object == FALSE) {
                stringBuffer.append("#f");
                return;
            }
            stringBuffer.append(object);
        }
    }

    static String stringify(Object object) {
        return SchemeUtils.stringify(object, true);
    }

    static String stringify(Object object, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        SchemeUtils.stringify(object, bl, stringBuffer);
        return stringBuffer.toString();
    }

    static Object p(Object object) {
        System.out.println(SchemeUtils.stringify(object));
        return object;
    }

    static Object p(String string, Object object) {
        System.out.println(String.valueOf(string) + ": " + SchemeUtils.stringify(object));
        return object;
    }
}

