/*
 * Decompiled with CFR 0.152.
 */
package silk;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import silk.Closure;
import silk.Environment;
import silk.InputPort;
import silk.Macro;
import silk.Pair;
import silk.Primitive;
import silk.Procedure;
import silk.SchemeUtils;

public class Scheme
extends SchemeUtils {
    InputPort input = new InputPort(System.in);
    PrintWriter output = new PrintWriter(System.out, true);
    Environment globalEnvironment = new Environment();

    public Scheme(String[] stringArray) {
        Primitive.installPrimitives(this.globalEnvironment);
        try {
            this.load(new InputPort(new StringReader("(define call/cc    call-with-current-continuation)\n(define first \t   car)\n(define second     cadr)\n(define third      caddr)\n(define rest \t   cdr)\n(define set-first! set-car!)\n(define set-rest!  set-cdr!)\n(define or\n(macro args\n(if (null? args)\n#f\n(cons 'cond (map list args)))))\n(define and\n(macro args\n(cond ((null? args) #t)\n((null? (rest args)) (first args))\n(else (list 'if (first args) (cons 'and (rest args)) #f)))))\n(define quasiquote\n(macro (x)\n(define (constant? exp)\n(if (pair? exp) (eq? (car exp) 'quote) (not (symbol? exp))))\n(define (combine-skeletons left right exp)\n(cond\n((and (constant? left) (constant? right))\n(if (and (eqv? (eval left) (car exp))\n(eqv? (eval right) (cdr exp)))\n(list 'quote exp)\n(list 'quote (cons (eval left) (eval right)))))\n((null? right) (list 'list left))\n((and (pair? right) (eq? (car right) 'list))\n(cons 'list (cons left (cdr right))))\n(else (list 'cons left right))))\n(define (expand-quasiquote exp nesting)\n(cond\n((vector? exp)\n(list 'apply 'vector (expand-quasiquote (vector->list exp) nesting)))\n((not (pair? exp))\n(if (constant? exp) exp (list 'quote exp)))\n((and (eq? (car exp) 'unquote) (= (length exp) 2))\n(if (= nesting 0)\n(second exp)\n(combine-skeletons ''unquote\n(expand-quasiquote (cdr exp) (- nesting 1))\nexp)))\n((and (eq? (car exp) 'quasiquote) (= (length exp) 2))\n(combine-skeletons ''quasiquote\n(expand-quasiquote (cdr exp) (+ nesting 1))\nexp))\n((and (pair? (car exp))\n(eq? (caar exp) 'unquote-splicing)\n(= (length (car exp)) 2))\n(if (= nesting 0)\n(list 'append (second (first exp))\n(expand-quasiquote (cdr exp) nesting))\n(combine-skeletons (expand-quasiquote (car exp) (- nesting 1))\n(expand-quasiquote (cdr exp) nesting)\nexp)))\n(else (combine-skeletons (expand-quasiquote (car exp) nesting)\n(expand-quasiquote (cdr exp) nesting)\nexp))))\n(expand-quasiquote x 0)))\n\n(define let\n(macro (bindings . body)\n(define (named-let name bindings body)\n`(let ((,name #f))\n(set! ,name (lambda ,(map first bindings) . ,body))\n(,name . ,(map second bindings))))\n(if (symbol? bindings)\n(named-let bindings (first body) (rest body))\n`((lambda ,(map first bindings) . ,body) . ,(map second bindings)))))\n(define let*\n(macro (bindings . body)\n(if (null? bindings) `((lambda () . ,body))\n`(let (,(first bindings))\n(let* ,(rest bindings) . ,body)))))\n(define letrec\n(macro (bindings . body)\n(let ((vars (map first bindings))\n(vals (map second bindings)))\n`(let ,(map (lambda (var) `(,var #f)) vars)\n,@(map (lambda (var val) `(set! ,var ,val)) vars vals)\n. ,body))))\n(define case\n(macro (exp . cases)\n(define (do-case case)\n(cond ((not (pair? case)) (error \"bad syntax in case\" case))\n((eq? (first case) 'else) case)\n(else `((member __exp__ ',(first case)) . ,(rest case)))))\n`(let ((__exp__ ,exp)) (cond . ,(map do-case cases)))))\n(define do\n(macro (bindings test-and-result . body)\n(let ((variables (map first bindings))\n(inits (map second bindings))\n(steps (map (lambda (clause)\n(if (null? (cddr clause))\n(first clause)\n(third clause)))\nbindings))\n(test (first test-and-result))\n(result (rest test-and-result)))\n`(letrec ((__loop__\n(lambda ,variables\n(if ,test\n(begin . ,result)\n(begin\n,@body\n(__loop__ . ,steps))))))\n(__loop__ . ,inits)))))\n(define delay\n(macro (exp)\n(define (make-promise proc)\n(let ((result-ready? #f)\n(result #f))\n(lambda ()\n(if result-ready?\nresult\n(let ((x (proc)))\n(if result-ready?\nresult\n(begin (set! result-ready? #t)\n(set! result x)\nresult)))))))\n`(,make-promise (lambda () ,exp))))\n(define time\n(macro (exp . rest) `(time-call (lambda () ,exp) . ,rest)))\n")));
            int n = 0;
            while (n < (stringArray == null ? 0 : stringArray.length)) {
                this.load(stringArray[n]);
                ++n;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        new Scheme(stringArray).readEvalWriteLoop();
    }

    public void readEvalWriteLoop() {
        while (true) {
            try {
                while (true) {
                    this.output.print("> ");
                    this.output.flush();
                    Object object = this.input.read();
                    if (InputPort.isEOF(object)) {
                        return;
                    }
                    SchemeUtils.write(this.eval(object), this.output, true);
                    this.output.println();
                    this.output.flush();
                }
            }
            catch (RuntimeException runtimeException) {
                continue;
            }
            break;
        }
    }

    public Object load(Object object) {
        String string = SchemeUtils.stringify(object, false);
        try {
            return this.load(new InputPort(new FileInputStream(string)));
        }
        catch (IOException iOException) {
            return SchemeUtils.error("can't load " + string);
        }
    }

    public Object load(InputPort inputPort) {
        Object object = null;
        while (!InputPort.isEOF(object = inputPort.read())) {
            this.eval(object);
        }
        return SchemeUtils.TRUE;
    }

    public Object eval(Object object, Environment environment) {
        Object object2;
        Object object3;
        while (true) {
            if (object instanceof String) {
                return environment.lookup((String)object);
            }
            if (!(object instanceof Pair)) {
                return object;
            }
            object3 = SchemeUtils.first(object);
            object2 = SchemeUtils.rest(object);
            if (object3 == "quote") {
                return SchemeUtils.first(object2);
            }
            if (object3 == "begin") {
                while (SchemeUtils.rest(object2) != null) {
                    this.eval(SchemeUtils.first(object2), environment);
                    object2 = SchemeUtils.rest(object2);
                }
                object = SchemeUtils.first(object2);
                continue;
            }
            if (object3 == "define") {
                if (SchemeUtils.first(object2) instanceof Pair) {
                    return environment.define(SchemeUtils.first(SchemeUtils.first(object2)), this.eval(SchemeUtils.cons("lambda", SchemeUtils.cons(SchemeUtils.rest(SchemeUtils.first(object2)), SchemeUtils.rest(object2))), environment));
                }
                return environment.define(SchemeUtils.first(object2), this.eval(SchemeUtils.second(object2), environment));
            }
            if (object3 == "set!") {
                return environment.set(SchemeUtils.first(object2), this.eval(SchemeUtils.second(object2), environment));
            }
            if (object3 == "if") {
                object = SchemeUtils.truth(this.eval(SchemeUtils.first(object2), environment)) ? SchemeUtils.second(object2) : SchemeUtils.third(object2);
                continue;
            }
            if (object3 == "cond") {
                object = this.reduceCond(object2, environment);
                continue;
            }
            if (object3 == "lambda") {
                return new Closure(SchemeUtils.first(object2), SchemeUtils.rest(object2), environment);
            }
            if (object3 == "macro") {
                return new Macro(SchemeUtils.first(object2), SchemeUtils.rest(object2), environment);
            }
            if ((object3 = this.eval(object3, environment)) instanceof Macro) {
                object = ((Macro)object3).expand(this, (Pair)object, object2);
                continue;
            }
            if (!(object3 instanceof Closure)) break;
            Closure closure = (Closure)object3;
            object = closure.body;
            environment = new Environment(closure.parms, this.evalList(object2, environment), closure.env);
        }
        return Procedure.proc(object3).apply(this, this.evalList(object2, environment));
    }

    public Object eval(Object object) {
        return this.eval(object, this.globalEnvironment);
    }

    Pair evalList(Object object, Environment environment) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Pair)) {
            SchemeUtils.error("Illegal arg list: " + object);
            return null;
        }
        return SchemeUtils.cons(this.eval(SchemeUtils.first(object), environment), this.evalList(SchemeUtils.rest(object), environment));
    }

    Object reduceCond(Object object, Environment environment) {
        Object object2;
        Object object3 = null;
        do {
            if (object == null) {
                return SchemeUtils.FALSE;
            }
            object2 = SchemeUtils.first(object);
            object = SchemeUtils.rest(object);
        } while (SchemeUtils.first(object2) != "else" && !SchemeUtils.truth(object3 = this.eval(SchemeUtils.first(object2), environment)));
        if (SchemeUtils.rest(object2) == null) {
            return SchemeUtils.list("quote", object3);
        }
        if (SchemeUtils.second(object2) == "=>") {
            return SchemeUtils.list(SchemeUtils.third(object2), SchemeUtils.list("quote", object3));
        }
        return SchemeUtils.cons("begin", SchemeUtils.rest(object2));
    }
}

