/*
 * Decompiled with CFR 0.152.
 */
package silk;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import silk.Continuation;
import silk.Environment;
import silk.InputPort;
import silk.JavaMethod;
import silk.Macro;
import silk.Pair;
import silk.Procedure;
import silk.Scheme;
import silk.SchemeUtils;

public class Primitive
extends Procedure {
    int minArgs;
    int maxArgs;
    int idNumber;
    private static final int EQ = 0;
    private static final int LT = 1;
    private static final int GT = 2;
    private static final int GE = 3;
    private static final int LE = 4;
    private static final int ABS = 5;
    private static final int EOF_OBJECT = 6;
    private static final int EQQ = 7;
    private static final int EQUALQ = 8;
    private static final int FORCE = 9;
    private static final int CAR = 10;
    private static final int FLOOR = 11;
    private static final int CEILING = 12;
    private static final int CONS = 13;
    private static final int DIVIDE = 14;
    private static final int LENGTH = 15;
    private static final int LIST = 16;
    private static final int LISTQ = 17;
    private static final int APPLY = 18;
    private static final int MAX = 19;
    private static final int MIN = 20;
    private static final int MINUS = 21;
    private static final int NEWLINE = 22;
    private static final int NOT = 23;
    private static final int NULLQ = 24;
    private static final int NUMBERQ = 25;
    private static final int PAIRQ = 26;
    private static final int PLUS = 27;
    private static final int PROCEDUREQ = 28;
    private static final int READ = 29;
    private static final int CDR = 30;
    private static final int ROUND = 31;
    private static final int SECOND = 32;
    private static final int SYMBOLQ = 33;
    private static final int TIMES = 34;
    private static final int TRUNCATE = 35;
    private static final int WRITE = 36;
    private static final int APPEND = 37;
    private static final int BOOLEANQ = 38;
    private static final int SQRT = 39;
    private static final int EXPT = 40;
    private static final int REVERSE = 41;
    private static final int ASSOC = 42;
    private static final int ASSQ = 43;
    private static final int ASSV = 44;
    private static final int MEMBER = 45;
    private static final int MEMQ = 46;
    private static final int MEMV = 47;
    private static final int EQVQ = 48;
    private static final int LISTREF = 49;
    private static final int LISTTAIL = 50;
    private static final int STRINQ = 51;
    private static final int MAKESTRING = 52;
    private static final int STRING = 53;
    private static final int STRINGLENGTH = 54;
    private static final int STRINGREF = 55;
    private static final int STRINGSET = 56;
    private static final int SUBSTRING = 57;
    private static final int STRINGAPPEND = 58;
    private static final int STRINGTOLIST = 59;
    private static final int LISTTOSTRING = 60;
    private static final int SYMBOLTOSTRING = 61;
    private static final int STRINGTOSYMBOL = 62;
    private static final int EXP = 63;
    private static final int LOG = 64;
    private static final int SIN = 65;
    private static final int COS = 66;
    private static final int TAN = 67;
    private static final int ACOS = 68;
    private static final int ASIN = 69;
    private static final int ATAN = 70;
    private static final int NUMBERTOSTRING = 71;
    private static final int STRINGTONUMBER = 72;
    private static final int CHARQ = 73;
    private static final int CHARALPHABETICQ = 74;
    private static final int CHARNUMERICQ = 75;
    private static final int CHARWHITESPACEQ = 76;
    private static final int CHARUPPERCASEQ = 77;
    private static final int CHARLOWERCASEQ = 78;
    private static final int CHARTOINTEGER = 79;
    private static final int INTEGERTOCHAR = 80;
    private static final int CHARUPCASE = 81;
    private static final int CHARDOWNCASE = 82;
    private static final int STRINGQ = 83;
    private static final int VECTORQ = 84;
    private static final int MAKEVECTOR = 85;
    private static final int VECTOR = 86;
    private static final int VECTORLENGTH = 87;
    private static final int VECTORREF = 88;
    private static final int VECTORSET = 89;
    private static final int LISTTOVECTOR = 90;
    private static final int MAP = 91;
    private static final int FOREACH = 92;
    private static final int CALLCC = 93;
    private static final int VECTORTOLIST = 94;
    private static final int LOAD = 95;
    private static final int DISPLAY = 96;
    private static final int INPUTPORTQ = 98;
    private static final int CURRENTINPUTPORT = 99;
    private static final int OPENINPUTFILE = 100;
    private static final int CLOSEINPUTPORT = 101;
    private static final int OUTPUTPORTQ = 103;
    private static final int CURRENTOUTPUTPORT = 104;
    private static final int OPENOUTPUTFILE = 105;
    private static final int CLOSEOUTPUTPORT = 106;
    private static final int READCHAR = 107;
    private static final int PEEKCHAR = 108;
    private static final int EVAL = 109;
    private static final int QUOTIENT = 110;
    private static final int REMAINDER = 111;
    private static final int MODULO = 112;
    private static final int THIRD = 113;
    private static final int EOFOBJECTQ = 114;
    private static final int GCD = 115;
    private static final int LCM = 116;
    private static final int CXR = 117;
    private static final int ODDQ = 118;
    private static final int EVENQ = 119;
    private static final int ZEROQ = 120;
    private static final int POSITIVEQ = 121;
    private static final int NEGATIVEQ = 122;
    private static final int CHARCMP = 123;
    private static final int CHARCICMP = 128;
    private static final int STRINGCMP = 133;
    private static final int STRINGCICMP = 138;
    private static final int EXACTQ = 143;
    private static final int INEXACTQ = 144;
    private static final int INTEGERQ = 145;
    private static final int CALLWITHINPUTFILE = 146;
    private static final int CALLWITHOUTPUTFILE = 147;
    static final int NEW = -1;
    static final int CLASS = -2;
    static final int METHOD = -3;
    static final int EXIT = -4;
    static final int SETCAR = -5;
    static final int SETCDR = -6;
    static final int TIMECALL = -11;
    static final int MACROEXPAND = -12;
    static final int ERROR = -13;
    static final int LISTSTAR = -14;

    public Primitive(int n, int n2, int n3) {
        this.idNumber = n;
        this.minArgs = n2;
        this.maxArgs = n3;
    }

    public static Environment installPrimitives(Environment environment) {
        int n = Integer.MAX_VALUE;
        environment.defPrim("*", 34, 0, n).defPrim("*", 34, 0, n).defPrim("+", 27, 0, n).defPrim("-", 21, 1, n).defPrim("/", 14, 1, n).defPrim("<", 1, 2, n).defPrim("<=", 4, 2, n).defPrim("=", 0, 2, n).defPrim(">", 2, 2, n).defPrim(">=", 3, 2, n).defPrim("abs", 5, 1).defPrim("acos", 68, 1).defPrim("append", 37, 0, n).defPrim("apply", 18, 2, n).defPrim("asin", 69, 1).defPrim("assoc", 42, 2).defPrim("assq", 43, 2).defPrim("assv", 44, 2).defPrim("atan", 70, 1).defPrim("boolean?", 38, 1).defPrim("caaaar", 117, 1).defPrim("caaadr", 117, 1).defPrim("caaar", 117, 1).defPrim("caadar", 117, 1).defPrim("caaddr", 117, 1).defPrim("caadr", 117, 1).defPrim("caar", 117, 1).defPrim("cadaar", 117, 1).defPrim("cadadr", 117, 1).defPrim("cadar", 117, 1).defPrim("caddar", 117, 1).defPrim("cadddr", 117, 1).defPrim("caddr", 113, 1).defPrim("cadr", 32, 1).defPrim("call-with-current-continuation", 93, 1).defPrim("call-with-input-file", 146, 2).defPrim("call-with-output-file", 147, 2).defPrim("car", 10, 1).defPrim("cdaaar", 117, 1).defPrim("cdaadr", 117, 1).defPrim("cdaar", 117, 1).defPrim("cdadar", 117, 1).defPrim("cdaddr", 117, 1).defPrim("cdadr", 117, 1).defPrim("cdar", 117, 1).defPrim("cddaar", 117, 1).defPrim("cddadr", 117, 1).defPrim("cddar", 117, 1).defPrim("cdddar", 117, 1).defPrim("cddddr", 117, 1).defPrim("cdddr", 117, 1).defPrim("cddr", 117, 1).defPrim("cdr", 30, 1).defPrim("char->integer", 79, 1).defPrim("char-alphabetic?", 74, 1).defPrim("char-ci<=?", 132, 2).defPrim("char-ci<?", 129, 2).defPrim("char-ci=?", 128, 2).defPrim("char-ci>=?", 131, 2).defPrim("char-ci>?", 130, 2).defPrim("char-downcase", 82, 1).defPrim("char-lower-case?", 78, 1).defPrim("char-numeric?", 75, 1).defPrim("char-upcase", 81, 1).defPrim("char-upper-case?", 77, 1).defPrim("char-whitespace?", 76, 1).defPrim("char<=?", 127, 2).defPrim("char<?", 124, 2).defPrim("char=?", 123, 2).defPrim("char>=?", 126, 2).defPrim("char>?", 125, 2).defPrim("char?", 73, 1).defPrim("close-input-port", 101, 1).defPrim("close-output-port", 106, 1).defPrim("complex?", 25, 1).defPrim("cons", 13, 2).defPrim("cos", 66, 1).defPrim("current-input-port", 99, 0).defPrim("current-output-port", 104, 0).defPrim("display", 96, 1, 2).defPrim("eof-object?", 114, 1).defPrim("eq?", 7, 2).defPrim("equal?", 8, 2).defPrim("eqv?", 48, 2).defPrim("eval", 109, 1, 2).defPrim("even?", 119, 1).defPrim("exact?", 145, 1).defPrim("exp", 63, 1).defPrim("expt", 40, 2).defPrim("force", 9, 1).defPrim("for-each", 92, 1, n).defPrim("gcd", 115, 0, n).defPrim("inexact?", 144, 1).defPrim("input-port?", 98, 1).defPrim("integer->char", 80, 1).defPrim("integer?", 145, 1).defPrim("lcm", 116, 0, n).defPrim("length", 15, 1).defPrim("list", 16, 0, n).defPrim("list->string", 60, 1).defPrim("list->vector", 90, 1).defPrim("list-ref", 49, 2).defPrim("list-tail", 50, 2).defPrim("list?", 17, 1).defPrim("load", 95, 1).defPrim("log", 64, 1).defPrim("macro-expand", -12, 1).defPrim("make-string", 52, 1, 2).defPrim("make-vector", 85, 1, 2).defPrim("map", 91, 1, n).defPrim("max", 19, 1, n).defPrim("member", 45, 2).defPrim("memq", 46, 2).defPrim("memv", 47, 2).defPrim("min", 20, 1, n).defPrim("modulo", 112, 2).defPrim("negative?", 122, 1).defPrim("newline", 22, 0, 1).defPrim("not", 23, 1).defPrim("null?", 24, 1).defPrim("number->string", 71, 1, 2).defPrim("number?", 25, 1).defPrim("odd?", 118, 1).defPrim("open-input-file", 100, 1).defPrim("open-output-file", 105, 1).defPrim("output-port?", 103, 1).defPrim("pair?", 26, 1).defPrim("peek-char", 108, 0, 1).defPrim("positive?", 121, 1).defPrim("procedure?", 28, 1).defPrim("quotient", 110, 2).defPrim("rational?", 145, 1).defPrim("read", 29, 0, 1).defPrim("read-char", 107, 0, 1).defPrim("real?", 25, 1).defPrim("remainder", 111, 2).defPrim("reverse", 41, 1).defPrim("round", 31, 1).defPrim("set-car!", -5, 2).defPrim("set-cdr!", -6, 2).defPrim("sin", 65, 1).defPrim("sqrt", 39, 1).defPrim("string", 53, 0, n).defPrim("string->list", 59, 1).defPrim("string->number", 72, 1, 2).defPrim("string->symbol", 62, 1).defPrim("string-append", 58, 0, n).defPrim("string-ci<=?", 142, 2).defPrim("string-ci<?", 139, 2).defPrim("string-ci=?", 138, 2).defPrim("string-ci>=?", 141, 2).defPrim("string-ci>?", 140, 2).defPrim("string-length", 54, 1).defPrim("string-ref", 55, 2).defPrim("string-set!", 56, 3).defPrim("string<=?", 137, 2).defPrim("string<?", 134, 2).defPrim("string=?", 133, 2).defPrim("string>=?", 136, 2).defPrim("string>?", 135, 2).defPrim("string?", 83, 1).defPrim("substring", 57, 3).defPrim("symbol->string", 61, 1).defPrim("symbol?", 33, 1).defPrim("tan", 67, 1).defPrim("vector", 86, 0, n).defPrim("vector->list", 94, 1).defPrim("vector-length", 87, 1).defPrim("vector-ref", 88, 2).defPrim("vector-set!", 89, 3).defPrim("vector?", 84, 1).defPrim("write", 36, 1, 2).defPrim("write-char", 96, 1, 2).defPrim("zero?", 120, 1).defPrim("new", -1, 1).defPrim("class", -2, 1).defPrim("method", -3, 2, n).defPrim("exit", -4, 0, 1).defPrim("error", -13, 0, n).defPrim("time-call", -11, 1, 2).defPrim("_list*", -14, 0, n);
        return environment;
    }

    public Object apply(Scheme scheme, Object object) {
        int n = SchemeUtils.length(object);
        if (n < this.minArgs) {
            return SchemeUtils.error("too few args, " + n + ", for " + this.name + ": " + object);
        }
        if (n > this.maxArgs) {
            return SchemeUtils.error("too many args, " + n + ", for " + this.name + ": " + object);
        }
        Object object2 = SchemeUtils.first(object);
        Object object3 = SchemeUtils.second(object);
        switch (this.idNumber) {
            case 23: {
                return SchemeUtils.truth(object2 == SchemeUtils.FALSE);
            }
            case 38: {
                return SchemeUtils.truth(object2 == SchemeUtils.TRUE || object2 == SchemeUtils.FALSE);
            }
            case 48: {
                return SchemeUtils.truth(SchemeUtils.eqv(object2, object3));
            }
            case 7: {
                return SchemeUtils.truth(object2 == object3);
            }
            case 8: {
                return SchemeUtils.truth(SchemeUtils.equal(object2, object3));
            }
            case 26: {
                return SchemeUtils.truth(object2 instanceof Pair);
            }
            case 17: {
                return SchemeUtils.truth(Primitive.isList(object2));
            }
            case 117: {
                int n2 = this.name.length() - 2;
                while (n2 >= 1) {
                    object2 = this.name.charAt(n2) == 'a' ? SchemeUtils.first(object2) : SchemeUtils.rest(object2);
                    --n2;
                }
                return object2;
            }
            case 13: {
                return SchemeUtils.cons(object2, object3);
            }
            case 10: {
                return SchemeUtils.first(object2);
            }
            case 30: {
                return SchemeUtils.rest(object2);
            }
            case -5: {
                return SchemeUtils.setFirst(object2, object3);
            }
            case -6: {
                return SchemeUtils.setRest(object2, object3);
            }
            case 32: {
                return SchemeUtils.second(object2);
            }
            case 113: {
                return SchemeUtils.third(object2);
            }
            case 24: {
                return SchemeUtils.truth(object2 == null);
            }
            case 16: {
                return object;
            }
            case 15: {
                return SchemeUtils.num(SchemeUtils.length(object2));
            }
            case 37: {
                if (object == null) {
                    return null;
                }
                return Primitive.append(object);
            }
            case 41: {
                return SchemeUtils.reverse(object2);
            }
            case 50: {
                int n3 = (int)SchemeUtils.num(object3);
                while (n3 > 0) {
                    object2 = SchemeUtils.rest(object2);
                    --n3;
                }
                return object2;
            }
            case 49: {
                int n4 = (int)SchemeUtils.num(object3);
                while (n4 > 0) {
                    object2 = SchemeUtils.rest(object2);
                    --n4;
                }
                return SchemeUtils.first(object2);
            }
            case 46: {
                return Primitive.memberAssoc(object2, object3, 'm', 'q');
            }
            case 47: {
                return Primitive.memberAssoc(object2, object3, 'm', 'v');
            }
            case 45: {
                return Primitive.memberAssoc(object2, object3, 'm', ' ');
            }
            case 43: {
                return Primitive.memberAssoc(object2, object3, 'a', 'q');
            }
            case 44: {
                return Primitive.memberAssoc(object2, object3, 'a', 'v');
            }
            case 42: {
                return Primitive.memberAssoc(object2, object3, 'a', ' ');
            }
            case 33: {
                return SchemeUtils.truth(object2 instanceof String);
            }
            case 61: {
                return SchemeUtils.sym(object2).toCharArray();
            }
            case 62: {
                return new String(SchemeUtils.str(object2)).intern();
            }
            case 25: {
                return SchemeUtils.truth(object2 instanceof Number);
            }
            case 118: {
                return SchemeUtils.truth(Math.abs(SchemeUtils.num(object2)) % 2.0 != 0.0);
            }
            case 119: {
                return SchemeUtils.truth(Math.abs(SchemeUtils.num(object2)) % 2.0 == 0.0);
            }
            case 120: {
                return SchemeUtils.truth(SchemeUtils.num(object2) == 0.0);
            }
            case 121: {
                return SchemeUtils.truth(SchemeUtils.num(object2) > 0.0);
            }
            case 122: {
                return SchemeUtils.truth(SchemeUtils.num(object2) < 0.0);
            }
            case 145: {
                return SchemeUtils.truth(Primitive.isExact(object2));
            }
            case 144: {
                return SchemeUtils.truth(!Primitive.isExact(object2));
            }
            case 1: {
                return Primitive.numCompare(object, '<');
            }
            case 2: {
                return Primitive.numCompare(object, '>');
            }
            case 0: {
                return Primitive.numCompare(object, '=');
            }
            case 4: {
                return Primitive.numCompare(object, 'L');
            }
            case 3: {
                return Primitive.numCompare(object, 'G');
            }
            case 19: {
                return Primitive.numCompute(object, 'X', SchemeUtils.num(object2));
            }
            case 20: {
                return Primitive.numCompute(object, 'N', SchemeUtils.num(object2));
            }
            case 27: {
                return Primitive.numCompute(object, '+', 0.0);
            }
            case 21: {
                return Primitive.numCompute(SchemeUtils.rest(object), '-', SchemeUtils.num(object2));
            }
            case 34: {
                return Primitive.numCompute(object, '*', 1.0);
            }
            case 14: {
                return Primitive.numCompute(SchemeUtils.rest(object), '/', SchemeUtils.num(object2));
            }
            case 110: {
                double d = SchemeUtils.num(object2) / SchemeUtils.num(object3);
                return SchemeUtils.num(d > 0.0 ? Math.floor(d) : Math.ceil(d));
            }
            case 111: {
                return SchemeUtils.num((long)SchemeUtils.num(object2) % (long)SchemeUtils.num(object3));
            }
            case 112: {
                long l = (long)SchemeUtils.num(object2);
                long l2 = (long)SchemeUtils.num(object3);
                long l3 = l % l2;
                return SchemeUtils.num(l * l2 > 0L || l3 == 0L ? l3 : l3 + l2);
            }
            case 5: {
                return SchemeUtils.num(Math.abs(SchemeUtils.num(object2)));
            }
            case 11: {
                return SchemeUtils.num(Math.floor(SchemeUtils.num(object2)));
            }
            case 12: {
                return SchemeUtils.num(Math.ceil(SchemeUtils.num(object2)));
            }
            case 35: {
                double d = SchemeUtils.num(object2);
                return SchemeUtils.num(d < 0.0 ? Math.ceil(d) : Math.floor(d));
            }
            case 31: {
                return SchemeUtils.num(Math.round(SchemeUtils.num(object2)));
            }
            case 63: {
                return SchemeUtils.num(Math.exp(SchemeUtils.num(object2)));
            }
            case 64: {
                return SchemeUtils.num(Math.log(SchemeUtils.num(object2)));
            }
            case 65: {
                return SchemeUtils.num(Math.sin(SchemeUtils.num(object2)));
            }
            case 66: {
                return SchemeUtils.num(Math.cos(SchemeUtils.num(object2)));
            }
            case 67: {
                return SchemeUtils.num(Math.tan(SchemeUtils.num(object2)));
            }
            case 69: {
                return SchemeUtils.num(Math.asin(SchemeUtils.num(object2)));
            }
            case 68: {
                return SchemeUtils.num(Math.acos(SchemeUtils.num(object2)));
            }
            case 70: {
                return SchemeUtils.num(Math.atan(SchemeUtils.num(object2)));
            }
            case 39: {
                return SchemeUtils.num(Math.sqrt(SchemeUtils.num(object2)));
            }
            case 40: {
                return SchemeUtils.num(Math.pow(SchemeUtils.num(object2), SchemeUtils.num(object3)));
            }
            case 71: {
                return Primitive.numberToString(object2, object3);
            }
            case 72: {
                return Primitive.stringToNumber(object2, object3);
            }
            case 115: {
                if (object == null) {
                    return SchemeUtils.ZERO;
                }
                return Primitive.gcd(object);
            }
            case 116: {
                if (object == null) {
                    return SchemeUtils.ONE;
                }
                return Primitive.lcm(object);
            }
            case 73: {
                return SchemeUtils.truth(object2 instanceof Character);
            }
            case 74: {
                return SchemeUtils.truth(Character.isLetter(SchemeUtils.chr(object2)));
            }
            case 75: {
                return SchemeUtils.truth(Character.isDigit(SchemeUtils.chr(object2)));
            }
            case 76: {
                return SchemeUtils.truth(Character.isWhitespace(SchemeUtils.chr(object2)));
            }
            case 77: {
                return SchemeUtils.truth(Character.isUpperCase(SchemeUtils.chr(object2)));
            }
            case 78: {
                return SchemeUtils.truth(Character.isLowerCase(SchemeUtils.chr(object2)));
            }
            case 79: {
                return new Double(SchemeUtils.chr(object2));
            }
            case 80: {
                return SchemeUtils.chr((char)SchemeUtils.num(object2));
            }
            case 81: {
                return SchemeUtils.chr(Character.toUpperCase(SchemeUtils.chr(object2)));
            }
            case 82: {
                return SchemeUtils.chr(Character.toLowerCase(SchemeUtils.chr(object2)));
            }
            case 123: {
                return SchemeUtils.truth(Primitive.charCompare(object2, object3, false) == 0);
            }
            case 124: {
                return SchemeUtils.truth(Primitive.charCompare(object2, object3, false) < 0);
            }
            case 125: {
                return SchemeUtils.truth(Primitive.charCompare(object2, object3, false) > 0);
            }
            case 126: {
                return SchemeUtils.truth(Primitive.charCompare(object2, object3, false) >= 0);
            }
            case 127: {
                return SchemeUtils.truth(Primitive.charCompare(object2, object3, false) <= 0);
            }
            case 128: {
                return SchemeUtils.truth(Primitive.charCompare(object2, object3, true) == 0);
            }
            case 129: {
                return SchemeUtils.truth(Primitive.charCompare(object2, object3, true) < 0);
            }
            case 130: {
                return SchemeUtils.truth(Primitive.charCompare(object2, object3, true) > 0);
            }
            case 131: {
                return SchemeUtils.truth(Primitive.charCompare(object2, object3, true) >= 0);
            }
            case 132: {
                return SchemeUtils.truth(Primitive.charCompare(object2, object3, true) <= 0);
            }
            case -13: {
                return SchemeUtils.error(SchemeUtils.stringify(object));
            }
            case 83: {
                return SchemeUtils.truth(object2 instanceof char[]);
            }
            case 52: {
                char[] cArray = new char[(int)SchemeUtils.num(object2)];
                if (object3 != null) {
                    char c = SchemeUtils.chr(object3);
                    int n5 = cArray.length - 1;
                    while (n5 >= 0) {
                        cArray[n5] = c;
                        --n5;
                    }
                }
                return cArray;
            }
            case 53: {
                return SchemeUtils.listToString(object);
            }
            case 54: {
                return SchemeUtils.num(SchemeUtils.str(object2).length);
            }
            case 55: {
                return SchemeUtils.chr(SchemeUtils.str(object2)[(int)SchemeUtils.num(object3)]);
            }
            case 56: {
                Object object4 = SchemeUtils.third(object);
                SchemeUtils.str((Object)object2)[(int)SchemeUtils.num((Object)object3)] = SchemeUtils.chr(object4);
                return object4;
            }
            case 57: {
                int n6 = (int)SchemeUtils.num(object3);
                int n7 = (int)SchemeUtils.num(SchemeUtils.third(object));
                return new String(SchemeUtils.str(object2), n6, n7 - n6).toCharArray();
            }
            case 58: {
                return Primitive.stringAppend(object);
            }
            case 59: {
                Pair pair = null;
                char[] cArray = SchemeUtils.str(object2);
                int n8 = cArray.length - 1;
                while (n8 >= 0) {
                    pair = SchemeUtils.cons(SchemeUtils.chr(cArray[n8]), pair);
                    --n8;
                }
                return pair;
            }
            case 60: {
                return SchemeUtils.listToString(object2);
            }
            case 133: {
                return SchemeUtils.truth(Primitive.stringCompare(object2, object3, false) == 0);
            }
            case 134: {
                return SchemeUtils.truth(Primitive.stringCompare(object2, object3, false) < 0);
            }
            case 135: {
                return SchemeUtils.truth(Primitive.stringCompare(object2, object3, false) > 0);
            }
            case 136: {
                return SchemeUtils.truth(Primitive.stringCompare(object2, object3, false) >= 0);
            }
            case 137: {
                return SchemeUtils.truth(Primitive.stringCompare(object2, object3, false) <= 0);
            }
            case 138: {
                return SchemeUtils.truth(Primitive.stringCompare(object2, object3, true) == 0);
            }
            case 139: {
                return SchemeUtils.truth(Primitive.stringCompare(object2, object3, true) < 0);
            }
            case 140: {
                return SchemeUtils.truth(Primitive.stringCompare(object2, object3, true) > 0);
            }
            case 141: {
                return SchemeUtils.truth(Primitive.stringCompare(object2, object3, true) >= 0);
            }
            case 142: {
                return SchemeUtils.truth(Primitive.stringCompare(object2, object3, true) <= 0);
            }
            case 84: {
                return SchemeUtils.truth(object2 instanceof Object[]);
            }
            case 85: {
                Object[] objectArray = new Object[(int)SchemeUtils.num(object2)];
                if (object3 != null) {
                    int n9 = 0;
                    while (n9 < objectArray.length) {
                        objectArray[n9] = object3;
                        ++n9;
                    }
                }
                return objectArray;
            }
            case 86: {
                return SchemeUtils.listToVector(object);
            }
            case 87: {
                return SchemeUtils.num(SchemeUtils.vec(object2).length);
            }
            case 88: {
                return SchemeUtils.vec(object2)[(int)SchemeUtils.num(object3)];
            }
            case 89: {
                Object object5 = SchemeUtils.third(object);
                SchemeUtils.vec((Object)object2)[(int)SchemeUtils.num((Object)object3)] = object5;
                return object5;
            }
            case 94: {
                return SchemeUtils.vectorToList(object2);
            }
            case 90: {
                return SchemeUtils.listToVector(object2);
            }
            case 109: {
                return scheme.eval(object2);
            }
            case 9: {
                if (!(object2 instanceof Procedure)) {
                    return object2;
                }
                return Procedure.proc(object2).apply(scheme, null);
            }
            case -12: {
                return Macro.macroExpand(scheme, object2);
            }
            case 28: {
                return SchemeUtils.truth(object2 instanceof Procedure);
            }
            case 18: {
                return Procedure.proc(object2).apply(scheme, SchemeUtils.listStar(SchemeUtils.rest(object)));
            }
            case 91: {
                return Primitive.map(Procedure.proc(object2), SchemeUtils.rest(object), scheme, SchemeUtils.list(null));
            }
            case 92: {
                return Primitive.map(Procedure.proc(object2), SchemeUtils.rest(object), scheme, null);
            }
            case 93: {
                RuntimeException runtimeException = new RuntimeException();
                Continuation continuation = new Continuation(runtimeException);
                try {
                    return Procedure.proc(object2).apply(scheme, SchemeUtils.list(continuation));
                }
                catch (RuntimeException runtimeException2) {
                    if (runtimeException2 == runtimeException) {
                        return continuation.value;
                    }
                    throw runtimeException2;
                }
            }
            case 114: {
                return SchemeUtils.truth(object2 == InputPort.EOF);
            }
            case 98: {
                return SchemeUtils.truth(object2 instanceof InputPort);
            }
            case 99: {
                return scheme.input;
            }
            case 100: {
                return Primitive.openInputFile(object2);
            }
            case 101: {
                return SchemeUtils.inPort(object2, scheme).close();
            }
            case 103: {
                return SchemeUtils.truth(object2 instanceof PrintWriter);
            }
            case 104: {
                return scheme.output;
            }
            case 105: {
                return Primitive.openOutputFile(object2);
            }
            case 147: {
                Object object6;
                PrintWriter printWriter = null;
                try {
                    printWriter = Primitive.openOutputFile(object2);
                    object6 = Procedure.proc(object3).apply(scheme, SchemeUtils.list(printWriter));
                }
                finally {
                    Object var25_31 = null;
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
                return object6;
            }
            case 146: {
                Object object7;
                InputPort inputPort = null;
                try {
                    inputPort = Primitive.openInputFile(object2);
                    object7 = Procedure.proc(object3).apply(scheme, SchemeUtils.list(inputPort));
                }
                finally {
                    Object var26_37 = null;
                    if (inputPort != null) {
                        inputPort.close();
                    }
                }
                return object7;
            }
            case 106: {
                SchemeUtils.outPort(object2, scheme).close();
                return SchemeUtils.TRUE;
            }
            case 107: {
                return SchemeUtils.inPort(object2, scheme).readChar();
            }
            case 108: {
                return SchemeUtils.inPort(object2, scheme).peekChar();
            }
            case 95: {
                return scheme.load(object2);
            }
            case 29: {
                return SchemeUtils.inPort(object2, scheme).read();
            }
            case 6: {
                return SchemeUtils.truth(InputPort.isEOF(object2));
            }
            case 36: {
                return SchemeUtils.write(object2, SchemeUtils.outPort(object3, scheme), true);
            }
            case 96: {
                return SchemeUtils.write(object2, SchemeUtils.outPort(object3, scheme), false);
            }
            case 22: {
                SchemeUtils.outPort(object2, scheme).println();
                SchemeUtils.outPort(object2, scheme).flush();
                return SchemeUtils.TRUE;
            }
            case -2: {
                try {
                    return Class.forName(SchemeUtils.stringify(object2, false));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return SchemeUtils.FALSE;
                }
            }
            case -1: {
                try {
                    return JavaMethod.toClass(object2).newInstance();
                }
                catch (ClassCastException classCastException) {
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
                return SchemeUtils.FALSE;
            }
            case -3: {
                return new JavaMethod(SchemeUtils.stringify(object2, false), object3, SchemeUtils.rest(SchemeUtils.rest(object)));
            }
            case -4: {
                System.exit(object2 == null ? 0 : (int)SchemeUtils.num(object2));
            }
            case -14: {
                return SchemeUtils.listStar(object);
            }
            case -11: {
                Runtime runtime = Runtime.getRuntime();
                runtime.gc();
                long l = System.currentTimeMillis();
                long l4 = runtime.freeMemory();
                Object object8 = SchemeUtils.FALSE;
                int n10 = object3 == null ? 1 : (int)SchemeUtils.num(object3);
                int n11 = 0;
                while (n11 < n10) {
                    object8 = Procedure.proc(object2).apply(scheme, null);
                    ++n11;
                }
                long l5 = System.currentTimeMillis() - l;
                long l6 = l4 - runtime.freeMemory();
                return SchemeUtils.cons(object8, SchemeUtils.list(SchemeUtils.list(SchemeUtils.num(l5), "msec"), SchemeUtils.list(SchemeUtils.num(l6), "bytes")));
            }
        }
        return SchemeUtils.error("internal error: unknown primitive: " + this + " applied to " + object);
    }

    public static char[] stringAppend(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        while (object instanceof Pair) {
            stringBuffer.append(SchemeUtils.stringify(SchemeUtils.first(object), false));
            object = SchemeUtils.rest(object);
        }
        return stringBuffer.toString().toCharArray();
    }

    public static Object memberAssoc(Object object, Object object2, char c, char c2) {
        while (object2 instanceof Pair) {
            boolean bl;
            Object object3 = c == 'm' ? SchemeUtils.first(object2) : SchemeUtils.first(SchemeUtils.first(object2));
            switch (c2) {
                case 'q': {
                    bl = object3 == object;
                    break;
                }
                case 'v': {
                    bl = SchemeUtils.eqv(object3, object);
                    break;
                }
                case ' ': {
                    bl = SchemeUtils.equal(object3, object);
                    break;
                }
                default: {
                    SchemeUtils.warn("Bad option to memberAssoc:" + c2);
                    return SchemeUtils.FALSE;
                }
            }
            if (bl) {
                if (c == 'm') {
                    return object2;
                }
                return SchemeUtils.first(object2);
            }
            object2 = SchemeUtils.rest(object2);
        }
        return SchemeUtils.FALSE;
    }

    public static Object numCompare(Object object, char c) {
        block7: while (SchemeUtils.rest(object) instanceof Pair) {
            double d = SchemeUtils.num(SchemeUtils.first(object));
            object = SchemeUtils.rest(object);
            double d2 = SchemeUtils.num(SchemeUtils.first(object));
            switch (c) {
                case '>': {
                    if (d > d2) continue block7;
                    return SchemeUtils.FALSE;
                }
                case '<': {
                    if (d < d2) continue block7;
                    return SchemeUtils.FALSE;
                }
                case '=': {
                    if (d == d2) continue block7;
                    return SchemeUtils.FALSE;
                }
                case 'L': {
                    if (d <= d2) continue block7;
                    return SchemeUtils.FALSE;
                }
                case 'G': {
                    if (d >= d2) continue block7;
                    return SchemeUtils.FALSE;
                }
                default: {
                    SchemeUtils.error("internal error: unrecognized op: " + c);
                    break;
                }
            }
        }
        return SchemeUtils.TRUE;
    }

    /*
     * Unable to fully structure code
     */
    public static Object numCompute(Object var0, char var1_1, double var2_2) {
        if (var0 != null) ** GOTO lbl35
        switch (var1_1) {
            case '-': {
                return SchemeUtils.num(0.0 - var2_2);
            }
            case '/': {
                return SchemeUtils.num(1.0 / var2_2);
            }
        }
        return SchemeUtils.num(var2_2);
lbl-1000:
        // 1 sources

        {
            var4_3 = SchemeUtils.num(SchemeUtils.first(var0));
            var0 = SchemeUtils.rest(var0);
            switch (var1_1) {
                case 'X': {
                    if (!(var4_3 > var2_2)) continue block12;
                    var2_2 = var4_3;
                    break;
                }
                case 'N': {
                    if (!(var4_3 < var2_2)) continue block12;
                    var2_2 = var4_3;
                    break;
                }
                case '+': {
                    var2_2 += var4_3;
                    break;
                }
                case '-': {
                    var2_2 -= var4_3;
                    break;
                }
                case '*': {
                    var2_2 *= var4_3;
                    break;
                }
                case '/': {
                    var2_2 /= var4_3;
                    break;
                }
                default: {
                    SchemeUtils.error("internal error: unrecognized op: " + var1_1);
                    break;
                }
            }
lbl35:
            // 10 sources

            ** while (var0 instanceof Pair)
        }
lbl36:
        // 1 sources

        return SchemeUtils.num(var2_2);
    }

    static int sign(int n) {
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    public static int charCompare(Object object, Object object2, boolean bl) {
        char c = SchemeUtils.chr(object);
        char c2 = SchemeUtils.chr(object2);
        if (bl) {
            c = Character.toLowerCase(c);
            c2 = Character.toLowerCase(c2);
        }
        return c - c2;
    }

    public static int stringCompare(Object object, Object object2, boolean bl) {
        if (object instanceof char[] && object2 instanceof char[]) {
            char[] cArray = (char[])object;
            char[] cArray2 = (char[])object2;
            int n = 0;
            while (n < cArray.length) {
                int n2;
                int n3 = n2 = !bl ? cArray[n] - cArray2[n] : Character.toUpperCase(cArray[n]) - Character.toUpperCase(cArray2[n]);
                if (n2 != 0) {
                    return n2;
                }
                ++n;
            }
            return cArray.length - cArray2.length;
        }
        SchemeUtils.error("expected two strings, got: " + SchemeUtils.stringify(SchemeUtils.list(object, object2)));
        return 0;
    }

    static Object numberToString(Object object, Object object2) {
        int n;
        int n2 = n = object2 instanceof Number ? (int)SchemeUtils.num(object2) : 10;
        if (n != 10 || SchemeUtils.num(object) == (double)Math.round(SchemeUtils.num(object))) {
            return Long.toString((long)SchemeUtils.num(object), n).toCharArray();
        }
        return object.toString().toCharArray();
    }

    static Object stringToNumber(Object object, Object object2) {
        int n = object2 instanceof Number ? (int)SchemeUtils.num(object2) : 10;
        try {
            if (n == 10) {
                return Double.valueOf(SchemeUtils.stringify(object, false));
            }
            return SchemeUtils.num(Long.parseLong(SchemeUtils.stringify(object, false), n));
        }
        catch (NumberFormatException numberFormatException) {
            return SchemeUtils.FALSE;
        }
    }

    static Object gcd(Object object) {
        long l = 0L;
        while (object instanceof Pair) {
            l = Primitive.gcd2(Math.abs((long)SchemeUtils.num(SchemeUtils.first(object))), l);
            object = SchemeUtils.rest(object);
        }
        return SchemeUtils.num(l);
    }

    static long gcd2(long l, long l2) {
        if (l2 == 0L) {
            return l;
        }
        return Primitive.gcd2(l2, l % l2);
    }

    static Object lcm(Object object) {
        long l = 1L;
        long l2 = 1L;
        while (object instanceof Pair) {
            long l3 = Math.abs((long)SchemeUtils.num(SchemeUtils.first(object)));
            l2 = Primitive.gcd2(l3, l);
            l = l2 == 0L ? l2 : l3 / l2 * l;
            object = SchemeUtils.rest(object);
        }
        return SchemeUtils.num(l);
    }

    static boolean isExact(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        double d = SchemeUtils.num(object);
        return d == (double)Math.round(d) && Math.abs(d) < 1.0296288486157342E17;
    }

    static PrintWriter openOutputFile(Object object) {
        try {
            return new PrintWriter(new FileWriter(SchemeUtils.stringify(object, false)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return (PrintWriter)SchemeUtils.error("No such file: " + SchemeUtils.stringify(object));
        }
        catch (IOException iOException) {
            return (PrintWriter)SchemeUtils.error("IOException: " + iOException);
        }
    }

    static InputPort openInputFile(Object object) {
        try {
            return new InputPort(new FileInputStream(SchemeUtils.stringify(object, false)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return (InputPort)SchemeUtils.error("No such file: " + SchemeUtils.stringify(object));
        }
        catch (IOException iOException) {
            return (InputPort)SchemeUtils.error("IOException: " + iOException);
        }
    }

    static boolean isList(Object object) {
        Object object2 = object;
        Object object3 = object;
        while (object3 != null) {
            if (object2 == SchemeUtils.rest(object3) || !(object3 instanceof Pair) || !(object2 instanceof Pair)) {
                return false;
            }
            object2 = SchemeUtils.rest(object2);
            if ((object3 = SchemeUtils.rest(object3)) == null) {
                return true;
            }
            if (!(object3 instanceof Pair)) {
                return false;
            }
            object3 = SchemeUtils.rest(object3);
        }
        return true;
    }

    static Object append(Object object) {
        if (SchemeUtils.rest(object) == null) {
            return SchemeUtils.first(object);
        }
        return Primitive.append2(SchemeUtils.first(object), Primitive.append(SchemeUtils.rest(object)));
    }

    static Object append2(Object object, Object object2) {
        if (object instanceof Pair) {
            return SchemeUtils.cons(SchemeUtils.first(object), Primitive.append2(SchemeUtils.rest(object), object2));
        }
        return object2;
    }

    static Pair map(Procedure procedure, Object object, Scheme scheme, Pair pair) {
        Pair pair2 = pair;
        if (SchemeUtils.rest(object) == null) {
            object = SchemeUtils.first(object);
            while (object instanceof Pair) {
                Object object2 = procedure.apply(scheme, SchemeUtils.list(SchemeUtils.first(object)));
                if (pair2 != null) {
                    pair2.rest = SchemeUtils.list(object2);
                    pair2 = pair2.rest;
                }
                object = SchemeUtils.rest(object);
            }
        } else {
            Procedure procedure2 = Procedure.proc(scheme.eval("car"));
            Procedure procedure3 = Procedure.proc(scheme.eval("cdr"));
            while (SchemeUtils.first(object) instanceof Pair) {
                Object object3 = procedure.apply(scheme, Primitive.map(procedure2, SchemeUtils.list(object), scheme, SchemeUtils.list(null)));
                if (pair2 != null) {
                    pair2.rest = SchemeUtils.list(object3);
                    pair2 = pair2.rest;
                }
                object = Primitive.map(procedure3, SchemeUtils.list(object), scheme, SchemeUtils.list(null));
            }
        }
        return (Pair)SchemeUtils.rest(pair);
    }
}

